<?php

namespace TsLib\Models\Catalogo;

use TsLib\Models\BaseModel;
use Illuminate\Support\Facades\Auth;

use TsLib\Models\Catalogo\Scopes\BrandScope;

class Brand extends BaseModel
{
    protected $table = "brands";

    protected static function booted()
    {
        static::addGlobalScope(new BrandScope);
    }

    public function getEngineersAttribute($value)
    {
        if($value == null)
        {
            return [];
        }
        else
        {
            $engs = json_decode($value);
            return array_map('intval', $engs);
        }
    }

    public function getUserHasAccessAttribute()
    {
        if(Auth::user())
            return in_array(Auth::user()->id, $this->engineers);
        else
            return false;
    }
}
