<?php

namespace TsLib\Models\Downloads;

use TsLib\Models\BaseModel;
use TsLib\Models\Downloads\Scopes\DownloadScope;

class Download extends BaseModel
{
    protected $table = 'downloads';

    public function getLinesAttribute()
    {
        return $this->lines_rel->pluck('line_id')->toArray();
    }

    public function lines_rel()
    {
        return $this->hasMany(\TsLib\Models\Downloads\DownloadLine::class);
    }

    public function getCategoriesAttribute()
    {
        return $this->categories_rel->pluck('category_id')->toArray();
    }

    public function categories_rel()
    {
        return $this->hasMany(\TsLib\Models\Downloads\DownloadCategory::class);
    }

    public function getSubcategoriesAttribute()
    {
        return $this->subcategories_rel->pluck('subcategory_id')->toArray();
    }

    public function subcategories_rel()
    {
        return $this->hasMany(\TsLib\Models\Downloads\DownloadSubCategory::class);
    }

    public function getBrandsAttribute()
    {
        return $this->brands_rel->pluck('brand_id')->toArray();
    }

    public function brands_rel()
    {
        return $this->hasMany(\TsLib\Models\Downloads\DownloadBrand::class);
    }
}
