<?php

namespace TsLib\Models\Downloads\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

use App\Models\UsuarioPlataformaAcceso;
use Illuminate\Support\Facades\Auth;

class DownloadScope implements Scope
{
    /**
     * Scope global, traer siemrpe los items activos y disponibles
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
        //$builder->where('active',true);
        if(Auth::user())
        {
            $access = UsuarioPlataformaAcceso::where('sales_rep_id', Auth::user()->id)->first();
            if($access == null || $access->access_level_id != 3)
            {
                $builder->where('sales_rep_id', Auth::user()->id);
            }
        }
        $builder->orderBy('name','asc');
    }
}
