<?php

namespace TsLib\Models\Catalogo;

use TsLib\Models\BaseModel;
use TsLib\Models\Catalogo\Scopes\CategoryScope;

class Category extends BaseModel
{
    protected $table = "category";

    protected static function booted()
    {
        static::addGlobalScope(new CategoryScope);
    }

    public function line()
    {
        return $this->hasMany(Line::class,'id','line_id');
    }

    public function subcategories()
    {
        return $this->hasMany(Subcategory::class, 'category_id');
    }

}
