<?php

namespace TsLib\Models\Downloads;

use TsLib\Models\BaseModel;
use TsLib\Models\Downloads\Scopes\DownloadScope;

use TsLib\Models\UsuarioPlataformaAcceso;
use Illuminate\Support\Facades\Auth;

class Download extends BaseModel
{
    protected $table = 'downloads';

    protected static function booted()
    {
        static::addGlobalScope(new DownloadScope);
    }

    public function scopeUserCreated($query)
    {
        if(Auth::user())
        {
            $access = UsuarioPlataformaAcceso::where('sales_rep_id', Auth::user()->id)->first();
            if($access == null || $access->access_level_id != 3)
            {
                $query->where('sales_rep_id', Auth::user()->id);
            }
        }
        else
        {
            $query->take(0);
        }
    }

    public function scopeActive($query)
    {
        $query->where('active',true);
    }

    public function getLinesAttribute()
    {
        return $this->lines_rel->pluck('line_id')->toArray();
    }

    public function lines_rel()
    {
        return $this->hasMany(\TsLib\Models\Downloads\DownloadLine::class);
    }

    public function getCategoriesAttribute()
    {
        return $this->categories_rel->pluck('category_id')->toArray();
    }

    public function categories_rel()
    {
        return $this->hasMany(\TsLib\Models\Downloads\DownloadCategory::class);
    }

    public function getSubcategoriesAttribute()
    {
        return $this->subcategories_rel->pluck('subcategory_id')->toArray();
    }

    public function subcategories_rel()
    {
        return $this->hasMany(\TsLib\Models\Downloads\DownloadSubCategory::class);
    }

    public function getBrandsAttribute()
    {
        return $this->brands_rel->pluck('brand_id')->toArray();
    }

    public function brands_rel()
    {
        return $this->hasMany(\TsLib\Models\Downloads\DownloadBrand::class);
    }

    public function employee()
    {
        return $this->hasOne(\TsLib\Models\Employee::class, 'id', 'sales_rep_id');
    }
}
