<?php 

namespace TsLib\Pay\Services;

use Illuminate\Support\Facades\Log;

use TsLib\Models\Contact;
use MercadoPago;
use Carbon\Carbon;

class TsMercadoPago {

    public function __construct()
    {
        MercadoPago\SDK::setAccessToken(config('ts-lib-pay.mercadoPago.keys.token'));
    }

    static public function getPreferenceId($user, $currency, $address, $shipping, $items,$seguro,$promoOnline,$tipoCambio,$cupon,$order,$autopago=false)
    {
        $customer = $user->customer_base;
        $response = ["status" => false, "id" => 0, "public" => config('mercadoPago.keys.public'), "initPoint" => ""];
        
        $shippingPrice = $shipping ? $shipping['importeTotal'] : 0;
        $amountPromo = $currency==='USD' ?  $promoOnline["amount"]/$tipoCambio : $promoOnline["amount"] ;

        $client = self::dataPayer($user,$customer,$address);
        $itemsResult = self::objectItemsMP($items,$currency);
        $listItems = $itemsResult["itemList"];
       
        // data envio
        $costoEnvio = 0;
        if($shippingPrice > 0){
            $secure = 0;
            if($seguro > 0){
                $secure =  $itemsResult["subtotal"]["sinIva"] * $seguro;
            }
            $costoEnvio = $shippingPrice + $secure;
            $taxCostoEnvio = $costoEnvio*0.16;
            $shipments = new MercadoPago\Shipments();  
            $shipments->cost = $costoEnvio+$taxCostoEnvio;
            $shipments->mode = "not_specified";
        }
        $total = $itemsResult["subtotal"]["conIva"];

        /**
         * Contine cupon se manda un solo objeto por el descuento del subtotal sin IVA
        **/
        if(count($cupon) > 0){

            $subtotal = $itemsResult["subtotal"]["sinIva"] - $cupon["discount"];
            $taxNew = $subtotal*0.16;

            $itemCupon = new MercadoPago\Item();
            $itemCupon->id = $cupon["idCupon"];
            $itemCupon->title = utf8_encode(utf8_decode("Venta de tecnosinergia - cupón de descuento"));
            $itemCupon->quantity = 1;
            $itemCupon->category_id = "others";
            $itemCupon->description = utf8_encode(utf8_decode("Cupón de descuento"));
            $itemCupon->unit_price = $subtotal + $taxNew;
            $itemCupon->currency_id = $currency;
            $listItems = [$itemCupon];
            
            // data promo online
            $discountPromo = 0;
            if($promoOnline["apply"]==true&&$order["originSubtotal"] >= $amountPromo){
                $discountPromo = ($subtotal + $taxNew + $costoEnvio) * $promoOnline["promo"];
                $itemPromo = new MercadoPago\Item();
                $itemPromo->id = "Promo".str_replace(".","",$promoOnline["promo"]);
                $itemPromo->title = utf8_encode(utf8_decode("Promoción de descuento"));
                $itemPromo->quantity = 1;
                $itemPromo->category_id = "others";
                $itemPromo->description = utf8_encode(utf8_decode("Promoción pago en línea"));
                $itemPromo->unit_price = -$discountPromo;
                $itemPromo->currency_id = $currency;
                $listItems[] = $itemPromo;
            }
            $total = ($subtotal + $taxNew)-$discountPromo;
        }else{
            // data promo online
            $discountPromo=0;
            if($promoOnline["apply"]==true&&$order["originSubtotal"] >= $amountPromo){
                $discountPromo = ($itemsResult["subtotal"]["conIva"] + $costoEnvio) * $promoOnline["promo"];
                $itemPromo = new MercadoPago\Item();
                $itemPromo->id = "Promo".str_replace(".","",$promoOnline["promo"]);
                $itemPromo->title = utf8_encode(utf8_decode("Promoción de descuento"));
                $itemPromo->quantity = 1;
                $itemPromo->category_id = "others";
                $itemPromo->description = utf8_encode(utf8_decode("Promoción pago en línea"));
                $itemPromo->unit_price = -$discountPromo;
                $itemPromo->currency_id = $currency;
                $listItems[] = $itemPromo;
            }
            $total = $itemsResult["subtotal"]["conIva"]-$discountPromo;
        }

        $preference = new MercadoPago\Preference();
        $preference->binary_mode = true;
        $preference->payer = $client;
        $preference->items = $listItems;
        if($shippingPrice > 0){
            $preference->shipments= $shipments;
        }

        Log::debug(vsprintf("TsLib/Pay order %s (preg -%s-)", [
            json_encode($order), preg_match_all("/P[0-9]{6}/", $order['orderCode'])
        ]));
        if(isset($order["orderCode"]) && preg_match_all("/P[0-9]{6}/", $order['orderCode']) > 0)
        {
            $preference->back_urls = [
                "success" => route('home.auto.response').sprintf("?app=mp&action=success&customer=%s&amount=%d",$user->name,$total),
                "failure" => route('home.auto.response').sprintf("?app=mp&action=failure&customer=%s&amount=%d",$user->name,$total),
                "pending" => route('home.auto.response').sprintf("?app=mp&action=pending&customer=%s&amount=%d",$user->name,$total)
            ];
            $preference->external_reference = $order["codeClient"]."-".$order["orderCode"];
            $preference->notification_url = url('/api/notification/mp/auto/payment?order_id='.$order["orderId"]);

            $methods = [];
            array_push($methods,["id" => "ticket"]);
            array_push($methods,["id" => "atm"]);
            //$preference->payment_methods = [
            //    "excluded_payment_types" => $methods
            //];
        }
        else
        {
            $preference->back_urls = [
                "success" => route('checkout.success.mp'),
                "failure" => route('checkout')."?app=mp&action=failure",
                "pending" => route('checkout.success.mp')
            ];
            $preference->external_reference = $order["codeClient"]."-". str_pad($order["orderId"],6,"0",STR_PAD_LEFT);  // poner el codigo como referencia de los pedidos de NS 
            $preference->notification_url = url('/api/notification/mp/orders?order_id='.$order["orderId"]);
        }

        try {
            $preference->save();
            if($preference){
                $response["status"] = true;
                $response["id"] = $preference->id;
                $response["initPoint"] = $preference->init_point;
            }
        } catch (\Exception $e) {
            Log::error(json_encode([
                "message" => "Error en pereferencia de MP . Error". $e->getMessage(),
                "dataCliente" => $client,
                "dataItems" => $listItems,
                "dataShipping"  => $shipments
            ]));
        }
        return $response;
    }

    private static function objectItemsMP($items,$currency)
    {
        $list = [];
        $sinIva = $conIva = 0;
        foreach($items as $i => $article) {

            $sinIva+=  $article->quantity * $article->item->price;
            $conIva+=  $article->quantity * ($article->item->price + ($article->item->price*0.16));

            $item = new MercadoPago\Item();
            $item->id = $article->item->id;
            $item->title =  $article->item->model." ".substr($article->item->description,0,40)."...";
            $item->quantity = $article->quantity;
            $item->unit_price = $article->item->price + ($article->item->price * 0.16);
            $item->currency_id = $currency;
            $item->category_id = "electronics";
            $item->description = "Venta de tecnosinergia";
            //fix para evitar errores de redondeo, MP solo maneja 2 digitos decimales en precios, lo que ocasiona perdidas en redondeo con multiples piezas
            $reminder = ($item->unit_price*100) - (round($item->unit_price, 2)*100);
            //reminder es el valor del 3er digito en el precio del articulo, cuando este valor multiplicado por la cantidad comprada es mayor que 1, es la diferencia (en centavos) de lo que se perderia, por lo que esto se activa cuando se pierde 1 centavo o mas
            if(($article->quantity * $reminder) >= 1)
            {
                $item->quantity = 1;
                $item->title = $article->quantity.'x'.$item->title;
                $item->unit_price = $item->unit_price * $article->quantity;
            }
            $list[] = $item;
        }
        return ["itemList" => $list,"subtotal" => ["conIva" => $conIva, "sinIva" => $sinIva ] ];
    }

    private static function dataPayer($user,$customer,$address){
        
        if($user->type = "customer"){
            $contactPrincipal = Contact::with(['user'])->where([['customer_id',$user->id],['main_contact','1']])->first();
            $name = $contactPrincipal ? $contactPrincipal->user->name : $user->name;
            $surname = $contactPrincipal ? $contactPrincipal->user->name : $user->name;
            $email = $contactPrincipal ? $contactPrincipal->user->email : $user->email;
        }else{
            $name = $user->name;
            $surname = $user->name;
            $email = $user->email;
        }

        $payer = new MercadoPago\Payer();  
        $payer->name = $name;  
        $payer->surname = $surname;
        $payer->email = $email;
        $payer->date_created = Carbon::now();
        $payer->phone = [
            "area_code" => "+52",
            "number" => $customer["phone"]
        ];
        if($address) {
            $payer->address = [
                "street_name" => $address['street'],
                "street_number" => $address['external_number'],
                "zip_code" => $address['zip']
            ];
        }
        return $payer;
    }
}