<?php 

namespace TsLib\Pay;

use App\Contact;
use TsLib\Rest\Services\Curl;

class TsKueskiPay extends {

    protected $token;

    protected $curl = null;

    public function __construct()
    {
        $this->curl = new Curl(config('kueskipay.keys.url'), null, ['CURLOPT_HTTPHEADER' = 
            [
                'Content-type:application/json',
                'Authorization: Bearer '.config('kueskipay.keys.api')
            ]
        ]);
    }

    public function getUrlPayment($user, $customer, $currency, $address, $shipping, $items,$seguro,$tipoCambio,$cupon,$order,$autopago=false)
    {
        $response = ["status" => false, "message" => "","orderTecno" => 0,"paymentIdKP" => 0, "urlRedirection" => ""];
        $shippingPrice = $shipping ? $shipping['importeTotal'] : 0;

        $dataOrder = $this->dataPayer($user,$customer,$address,$shipping);
        $itemsResult = $this->objectItemsMP($items,$currency);
        $listItems = $itemsResult["itemList"];

        // data envio
        $costoEnvio = $taxCostoEnvio =0;
        if($shippingPrice > 0){
            $secure = 0;
            if($seguro > 0){
                $secure =  $itemsResult["subtotal"]["sinIva"] * $seguro;
            }
            $costoEnvio = round($shippingPrice + $secure,2);
            $taxCostoEnvio = round($costoEnvio*0.16,2);
        }

        $subtotalOrder = round($itemsResult["subtotal"]["sinIva"],2);
        $totalOrder = round($itemsResult["subtotal"]["conIva"] + $costoEnvio + $taxCostoEnvio,2);
        $taxOrder = round($taxCostoEnvio + ($itemsResult["subtotal"]["sinIva"] * 0.16),2);

        /**
         * Contine cupon se manda un solo objeto por el descuento del subtotal sin IVA
        **/
        if(count($cupon) > 0){
            $subtotalCupon = $itemsResult["subtotal"]["sinIva"] - $cupon["discount"];
            $taxCupon = $subtotalCupon*0.16;
           
            $itemCupon = [
                "name" => $cupon["idCupon"],
                "description" => utf8_encode(utf8_decode("Venta de tecnosinergia - cupón de descuento")),
                "quantity" => 1,
                "price" => $subtotalCupon,
                "currency" => $currency,
                "sku" => $cupon["idCupon"]
            ];
            $listItems=$itemCupon;

            $subtotalOrder = $subtotalCupon;
            $taxOrder = round($taxCupon+$taxCostoEnvio,2);
            $totalOrder = $subtotalOrder+$taxOrder+ $costoEnvio;
        
        }
       
        $amountOrder = [
            "total" => $totalOrder,
            "currency" => $currency,
            "details" => [
                "subtotal" => $subtotalOrder,
                "shipping" => $costoEnvio,
                "tax" => $taxOrder
            ]
        ];

        if($shipping){
            $jsonKP["shipping"] = $dataOrder["shipping"];
        }

        if($autopago===true){
            $reference = $order["orderCode"]."-".$order["orderId"];
            $urls = [
                "on_success" => route('home.auto.response').sprintf("?app=kp&action=success&customer=%s&amount=%d",$user->name,$totalOrder),
                "on_reject" => route('home.auto.response').sprintf("?app=kp&action=reject&customer=%s&amount=%d",$user->name,$totalOrder),
                "on_canceled" => route('home.auto.response').sprintf("?app=kp&action=canceled&customer=%s&amount=%d",$user->name,$totalOrder),
                "on_failed" => route('home.auto.response').sprintf("?app=kp&action=failed&customer=%s&amount=%d",$user->name,$totalOrder),
            ];
        }else{
            $reference = $order["codeClient"]."-".str_pad($order["orderId"],6,"0",STR_PAD_LEFT);
            $urls = [
                "on_success" => route('checkout.success.kp')."?order_id=".$order["orderId"],
                "on_reject" => route('checkout')."?app=kp&action=reject",
                "on_canceled" => route('checkout')."?app=kp&action=canceled",
                "on_failed" => route('checkout')."?app=kp&action=failed",
            ];
        }

        $jsonKP = [
            "order_id" => $reference,
            "description" => "Venta de Tecnosinergia",
            "amount" => $amountOrder,
            "items" => $listItems,
            "billing" => $dataOrder["billing"],
            "callbacks" => $urls
        ];

        //validar JSON
        try {
            $responseKP = $this->curl->post($jsonKP);
            if($responseKP != null){
                if(property_exists($responseKP,'status')){
                    if($responseKP->status == 'success'){
                        $response["status"] = true;
                        $response["orderTecno"] = $responseKP->data->order_id;
                        $response["paymentIdKP"] = $responseKP->data->payment_id;
                        $response["urlRedirection"] = $responseKP->data->callback_url;
                    }else{
                        $error = "";
                        if(property_exists($responseKP,'code')){
                            $error .= $responseKP->code;
                        }
                        $error .= "-".$responseKP->message;
                        $response["message"] = "Error al obtener datos del servicio de kueskipay. Error : ".$error;
                    }
                }
            }else{
                $response["message"] = "Error al obtener datos del servicio de kueskipay. Error : Response-curl_client null ";
            }
        } catch (\Exception $e) {
            $response["message"] = "Exception found. Error : ".$e->getMessage();
        }
        return $response;
    }

    public function objectItemsMP($items,$currency)
    {
        $list = [];
        $sinIva = $conIva = 0;
        foreach($items as $i => $article) {
            $sinIva+=  $article->quantity * $article->item->price;
            $conIva+=  $article->quantity * ($article->item->price + ($article->item->price*0.16));
            $item = [
                    "name" => $article->item->model,
                    "description" => substr($article->item->description,0,40)."...",
                    "quantity" => $article->quantity,
                    "price" => (Double) round($article->item->price,2),
                    "currency" => $currency,
                    "sku" => $article->item->code
            ];
            $list[] = $item;
        }
        return ["itemList" => $list,"subtotal" => ["conIva" => $conIva, "sinIva" => $sinIva ] ];
    }

    public function dataPayer($user,$customer,$address,$shipping)
    { 
        if($user->type = "customer"){
            $contactPrincipal = Contact::with(['user'])->where([['customer_id',$user->id],['main_contact','1']])->first();
            if($contactPrincipal != null && $contactPrincipal->user != null)
                $name = $contactPrincipal->user->name;
            else
                $name = 'SIN DATOS';
                $email = $user->email;
        }else{
            $name = $user->name;
            $email = $user->email;
        }

        $shipping = [
            "name" => [
                "name" => html_entity_decode($name),
                "last" => html_entity_decode($name)
            ],
            "address" => [
                "address" => $shipping ? utf8_encode(utf8_decode($address["street"])) : "",
                "interior" => $shipping ? $address["external_number"].", No. Int.".$address["internal_number"] : "",
                "neighborhood" => $shipping ? utf8_encode(utf8_decode($address["suburb"])) : "",
                "city" => $shipping ? $address["city"] : "",
                "state" => $shipping ? $address["state"] : "",
                "zipcode" => $shipping ? $address["zip"] : "",
                "country" => $shipping ? utf8_encode(utf8_decode($address["country"])) : "",
            ],
            "phone_number" => $customer["phone"],
            "email" => $email
        ];

        $billing = [
            "business" => [
                "name" => html_entity_decode($name),
                "rfc" => $customer["rfc"]
            ],
            "address" => [
                "address" => $address["street"],
                "neighborhood" => $address["suburb"],
                "city" => $address["city"],
                "state" => $address["state"],
                "zipcode" => $address["zip"],
                "country" => "MX",
            ],
            "phone_number" => $customer["phone"],
            "email" => $email
        ];

        return ["shipping" => $shipping, "billing" => $billing];
    }

}