<?php

namespace TsLib\Pay\Controllers;

use TsLib\Pay\Services\TsMercadoPago as MpService;
use TsLib\Pay\Services\TsKueskiPay as KpService;

use Illuminate\Http\Request;

class PaymentsController
{
    /**
     * 
     * 
     * @paramas $items
     *      {[id : 0, code : '', model : '', description : '', quantity : 0 , price : 0 ], [], ...}
     * 
     * @paramas $order
     *  {currency : {}, details : {}, cupon : {}, address : {}, shipping : {}, secure : {}}
     * 
     */

    public function loadmp(Request $request)
    {
        $user = auth()->user();
        $order = json_decode(json_encode($request->get('order')));
        $items = json_decode(json_encode($request->get('items')));
        
        $response = MpService::getPreferenceId($user, $order, $items);
        return $response;
    }

    public function loadkp(Request $request, KpService $kp)
    {
        $user = auth()->user();
        $order = json_decode(json_encode($request->get('order')));
        $items = json_decode(json_encode($request->get('items')));
        
        $response = $kp->getUrlPayment($user, $order, $items);
        return $response;
    }
 
}