<?php 

namespace TsLib\Pay\Services;


use TsLib\Rest\Services\Curl;
use Illuminate\Support\Facades\Log;

class TsKueskiPay {

    protected $token;

    protected $curl = null;

    public function __construct()
    {
        $header = ["type" => "header_kp", "token" => config('ts-lib-pay.kueskipay.keys.api')];
        $this->curl = new Curl(config('ts-lib-pay.kueskipay.keys.url'), $header);
    }

    public function getUrlPayment($user, $order, $items)
    {
        $response = ["status" => false, "message" => "","orderTecno" => 0,"paymentIdKP" => 0, "urlRedirection" => ""];
    
        $dataOrder = $this->dataPayer($user,$order);
        $itemsResult = $this->objectItemsMP($items,$order->currency);
        $listItems = $itemsResult["itemList"];

        /**
         * Contine cupon se manda un solo objeto por el descuento del subtotal sin IVA
        **/
        if(isset($order->cupon->idCupon)){
            $itemCupon = [
                "name" => $order->cupon->codeCupon,
                "description" => utf8_encode(utf8_decode("Venta de tecnosinergia - cupón de descuento")),
                "quantity" => 1,
                "price" => $order->detail->subtotalCupon,
                "currency" => $order->currency->name,
                "sku" => $order->cupon->codeCupon
            ];
            $listItems=[$itemCupon];
        }
       
        // data envio
        $shippingPrice = $order->detail->envio + $order->detail->secure;

        $amountOrder = [
            "total" => $order->detail->total,
            "currency" => $order->currency->name,
            "details" => [
                "subtotal" => $order->detail->subtotalCupon,
                "shipping" => $shippingPrice,
                "tax" => $order->detail->iva
            ]
        ];

        if($order->detail->envio > 0){
            $jsonKP["shipping"] = $dataOrder["shipping"];
        }

        $idOrder = str_pad($order->orderId, 6, "0", STR_PAD_LEFT);
        //autopago
        if(isset($order->orderId) && preg_match_all("/P[0-9]{6}/", $order->orderId > 0)){
            $reference = $order["orderCode"]."-".$idOrder;
            $urls = [
                "on_success" => route('home').sprintf("?app=kp&action=success&customer=%s&amount=%d",$user->name,$totalOrder),
                "on_reject" => route('home').sprintf("?app=kp&action=reject&customer=%s&amount=%d",$user->name,$totalOrder),
                "on_canceled" => route('home').sprintf("?app=kp&action=canceled&customer=%s&amount=%d",$user->name,$totalOrder),
                "on_failed" => route('home').sprintf("?app=kp&action=failed&customer=%s&amount=%d",$user->name,$totalOrder),
            ];
        }else{
            
            $reference = $order->codeClient."-".$idOrder; 
            $urls = [
                "on_success" => route('order.success')."?app=kp&action=success&order_id=".$order->orderId,
                "on_reject" => route('shopping.create.order')."?app=kp&action=reject",
                "on_canceled" => route('shopping.create.order')."?app=kp&action=canceld",
                "on_failed" => route('shopping.create.order')."?app=kp&action=failed",
            ];
        }

        $jsonKP = [
            "order_id" => $reference,
            "description" => "Venta de Tecnosinergia",
            "amount" => $amountOrder,
            "items" => $listItems,
            "billing" => $dataOrder["billing"],
            "callbacks" => $urls
        ];
        //dd($jsonKP);
        //validar JSON
        try {
            $responseKP =  $this->curl->post(config('ts-lib-pay.kueskipay.keys.url'),$jsonKP,[],true);
            //dd(122,$responseKP);
            if($responseKP != null){
                if(isset($responseKP["body"]->status) && $responseKP["body"]->status == 'success'){
                    $response["status"] = true;
                    $response["orderTecno"] = $responseKP["body"]->data->order_id;
                    $response["paymentIdKP"] = $responseKP["body"]->data->payment_id;
                    $response["urlRedirection"] = $responseKP["body"]->data->callback_url;
                }else if(isset($responseKP["body"]->status) && $responseKP["body"]->status == 'faild'){
                    $response["message"] = "Error al obtener datos del servicio de kueskipay. Error : ".$responseKP["body"]->message;
                }
            }else{
                $response["message"] = "Error al obtener datos del servicio de kueskipay. Error : Response-curl_client null ";
            }
        } catch (\Exception $e) {
            $response["message"] = "Exception found. Error : ".$e->getMessage();
        }
        Log::error(vsprintf("Response KP %s", [
            $response["message"],
        ]));
        return $response;
    }

    public function objectItemsMP($items,$currency)
    {
        $list = [];
        $sinIva = $conIva = 0;
        foreach($items as $article) {

            $sinIva+=  round($article->quantity * $article->price,2);
            $conIva+=  round($article->quantity * ($article->price + ($article->price*0.16)),2);

            $item = [
                    "name" => $article->model,
                    "description" => substr($article->description,0,40)."...",
                    "quantity" => $article->quantity,
                    "price" => (Double) round($article->price,2),
                    "currency" => $currency->name,
                    "sku" => $article->code
            ];
            $list[] = $item;
        }
        return ["itemList" => $list,"subtotal" => ["conIva" => $conIva, "sinIva" => $sinIva ] ];
    }

    public function dataPayer($user,$order)
    { 

        if($user->type = "customer"){
            $mainContact = $user->maincontact;
            $name = $mainContact ? $mainContact->user->name : $user->name;
            $email = $mainContact ? $mainContact->user->email : $user->email;
        }else{
            $name = $user->name;
            $email = $user->email;
        }

        $shipping = [];
        if($order->detail->envio > 0){
            $address = $order->address->address;
            $shipping = [
                "name" => [
                    "name" => html_entity_decode($name),
                    "last" => html_entity_decode($name)
                ],
                "address" => [
                    "address" => $address->street,
                    "interior" => $address->external_number.", No. Int.".$address->internal_number,
                    "neighborhood" => utf8_encode(utf8_decode($address->suburb)) ,
                    "city" => $address->city,
                    "state" => $address->state,
                    "zipcode" => $address->zip,
                    "country" => utf8_encode(utf8_decode($address->country)),
                ],
                "phone_number" => $user->customer->phone,
                "email" => $email
            ];
        }
        
        $addressBilling = $user->addressbilling;
        $billing = [
            "business" => [
                "name" => html_entity_decode($name),
                "rfc" => $user->customer->rfc,
            ],
            "address" => [
                "address" => $addressBilling->street,
                "neighborhood" => $addressBilling->suburb,
                "city" => $addressBilling->city,
                "state" => $addressBilling->state,
                "zipcode" => $addressBilling->zip,
                "country" => "MX",
            ],
            "phone_number" => $user->customer->phone,
            "email" => $email
        ];

        return ["shipping" => $shipping, "billing" => $billing];
    }

}