<?php 

namespace TsLib\Pay\Services;

use Illuminate\Support\Facades\Log;

use MercadoPago;
use Carbon\Carbon;

class TsMercadoPago {

    static public function getPreferenceId($user, $order, $items)
    {
        MercadoPago\SDK::setAccessToken(config('ts-lib-pay.mercadopago.keys.token'));

        $response = ["status" => false, "id" => 0, "public" => config('ts-lib-pay.mercadopago.keys.public'), "initPoint" => ""];
        
        $cliente = self::dataPayer($user,$order->address);
        $itemsResult = self::objectItemsMP($items,$order->currency);

        $listItems = $itemsResult["itemList"];
       
        // data envio
        $shippingPrice = $order->detail->envio + $order->detail->secure;
        $taxShipping = 0;
        if($shippingPrice > 0){
            $taxShipping = round($shippingPrice * 0.16,2);
            $shipments = new MercadoPago\Shipments();  
            $shipments->cost = $shippingPrice + $taxShipping;
            $shipments->mode = "not_specified";
        }
        
        /**
         *
         * Contine cupon se manda un solo objeto por el descuento del subtotal con IVA
        **/
        if(isset($order->cupon->idCupon)){
            $itemCupon = new MercadoPago\Item();
            $itemCupon->id = $order->cupon->codeCupon;
            $itemCupon->title = utf8_encode(utf8_decode("Venta de Tecnosinergia - cupón de descuento"));
            $itemCupon->quantity = 1;
            $itemCupon->category_id = "others";
            $itemCupon->description = utf8_encode(utf8_decode("Cupón de descuento"));

            // se quita taxShipping ya que viene incluido en $order->detail->iva
            $itemCupon->unit_price = ($order->detail->subtotalCupon - $taxShipping) + $order->detail->iva;

            $itemCupon->currency_id = $order->currency->name;
            $listItems = [$itemCupon];
        }
        $preference = new MercadoPago\Preference();
        $preference->binary_mode = true;
        $preference->payer = $cliente;
        $preference->items = $listItems;
        if($shippingPrice > 0){
            $preference->shipments= $shipments;
        }

        $idOrder = str_pad($order->orderId, 6, "0", STR_PAD_LEFT);
        //autopago
        if(isset($order->orderId) && preg_match_all("/P[0-9]{6}/", $order->orderId )>0){
            $preference->back_urls = [
                "success" => route('home').sprintf("?app=mp&action=success&customer=%s&amount=%d",$user->name,$order->detail->total),
                "failure" => route('home').sprintf("?app=mp&action=failure&customer=%s&amount=%d",$user->name,$order->detail->total),
                "pending" => route('home').sprintf("?app=mp&action=pending&customer=%s&amount=%d",$user->name,$order->detail->total)
            ];
            $preference->external_reference = $idOrder;
            $preference->notification_url = 'https://old.tecnosinergia.info/api/notification/mp/auto/payment?order_id='.$order->tsId;

        }else{  // portal
            $preference->back_urls = [
                "success" => route('order.success')."?app=mp&action=success",
                "failure" => route('shopping.create.order')."?app=mp&action=failure",
                "pending" => route('order.success')."?app=mp&action=pending",
            ];
            $preference->external_reference = $order->codeClient."-".$idOrder; 
            $preference->notification_url = 'https://old.tecnosinergia.info/api/notification/mp/orders?order_id='.$order->orderId;
        }

        try {
            $preference->save();
            if($preference->error != null){
                Log::error(vsprintf("Response MP preferencia %s", [
                    json_encode($preference->error),
                ]));
            }
            
            if($preference){
                $response["status"] = true;
                $response["id"] = $preference->id;
                $response["initPoint"] = $preference->init_point;
            }
        } catch (\Exception $e) {
            Log::error(json_encode([
                "message" => "Error en pereferencia de MP . Error". $e->getMessage(),
                "dataCliente" => $client,
                "dataItems" => $listItems,
                "dataShipping"  => $shipments
            ]));
        }
        return $response;
    }

    private static function objectItemsMP($items,$currency)
    {
        $list = [];
        $sinIva = $conIva = 0;
        foreach($items as $prod) {

            $sinIva+=  round($prod->quantity * $prod->price,2);
            $conIva+=  round($prod->quantity * ($prod->price + ($prod->price*0.16)),2);

            $item = new MercadoPago\Item();
            $item->id = $prod->id;
            $item->title = sprintf("%s %s...",$prod->model,substr($prod->description,0,40));
            $item->quantity = $prod->quantity;
            $item->unit_price = round($prod->price + ($prod->price * 0.16),2);
            $item->currency_id = $currency->name;
            $item->category_id = "electronics";
            $item->description = "Venta de Tecnosinergia";

            //fix para evitar errores de redondeo, MP solo maneja 2 digitos decimales en precios, lo que ocasiona perdidas en redondeo con multiples piezas
            $reminder = ($item->unit_price*100) - (round($item->unit_price, 2)*100);
            //reminder es el valor del 3er digito en el precio del articulo, 
            //cuando este valor multiplicado por la cantidad comprada es mayor que 1, es la diferencia 
            //(en centavos) de lo que se perderia, por lo que esto se activa cuando se pierde 1 centavo o mas
            //dd($reminder);
            if(($prod->quantity * $reminder) >= 1){
                $item->quantity = 1;
                $item->title = $article->quantity.'x'.$item->title;
                $item->unit_price = $item->unit_price * $article->quantity;
            }
            $list[] = $item;
        }
        return ["itemList" => $list,"subtotal" => ["conIva" => $conIva, "sinIva" => $sinIva ] ];
    }

    private static function dataPayer($user,$address=null)
    {
        if($user->type = "customer"){
            $mainContact = $user->maincontact;
            $name = $mainContact ? $mainContact->user->name : $user->name;
            $surname = $mainContact ? $mainContact->user->name : $user->name;
            $email = $mainContact ? $mainContact->user->email : $user->email;
        }else{
            $name = $user->name;
            $surname = $user->name;
            $email = $user->email;
        }

        $payer = new MercadoPago\Payer();  
        $payer->name = $name;  
        $payer->surname = $surname;
        $payer->email = $email;
        $payer->date_created = Carbon::now();
        $payer->phone = [
            "area_code" => "+52",
            "number" => $user->customer->phone
        ];
        
        if($address != null) {
            $payer->address = [
                "street_name" => $address->address->street,
                "street_number" => $address->address->external_number,
                "zip_code" => $address->address->zip
            ];
        }

        return $payer;
    }

    public function SearchPaymentMP($id)
    {
        MercadoPago\SDK::setAccessToken(config('ts-lib-pay.mercadopago.keys.token'));
        $methodPayemnt = $status = "";
        $amountPayment = 0;
        try {
            $payment = MercadoPago\Payment::find_by_id($id);
            if($payment){
                $status = $payment->status;
                $amountPayment = $payment->transaction_details->total_paid_amount;
                switch ($payment->payment_type_id) {
                    case 'account_money':
                        $methodPayemnt = "linea";
                        break;
                    case 'ticket':
                        $methodPayemnt = "offline";
                        break;
                    case 'bank_transfer':
                        $methodPayemnt = "offline";
                        break;
                    case 'atm':
                        $methodPayemnt = "linea";
                        break;
                    case 'prepaid_card':
                        $methodPayemnt = "linea";
                        break;
                    default:
                        $methodPayemnt = "linea";
                }
            }
        } catch (\Exception $e) {
            return [
                "message" => "Error al buscar payemnt : ". $e->getMessage(),
                "idPayment" => $id,
                "method" => $methodPayemnt,
                "status" => $status,
                "amountPayment" => $amountPayment
            ];
        }
        
        return [
            "message" => "payment found",
            "idPayment" => $id,
            "method" => $methodPayemnt,
            "status" => $status,
            "amountPayment" => $amountPayment,
            "payment" => $payment
        ];
    }

    public function notificationMerchantOrder($id)
    {
        MercadoPago\SDK::setAccessToken(config('ts-lib-pay.mercadopago.keys.token'));
        try {
            $merchant_order = MercadoPago\MerchantOrder::find_by_id($id);
            $resultOrder = $this->ProcessNatification($merchant_order);
        } catch (\Exception $e) {
            return ["message" => "Error MerchantOrder MP : ". $e->getMessage()];
        }
        
        return $resultOrder;
    }

    public function searchMerchantOrder($id)
    {
        MercadoPago\SDK::setAccessToken(config('ts-lib-pay.mercadopago.keys.token'));
        $merchant_order = MercadoPago\MerchantOrder::find_by_id($id);
        return $merchant_order;
    }
}