<?php

namespace TsLib\Pay\Controllers;

use TsLib\Pay\Services\TsMercadoPago as MpService;
use TsLib\Pay\Services\TsKueskiPay as KpService;
use TsLib\Pay\Services\TsKalto as KtService;

use TsLib\Rest\Services\NetsuiteRestlet;

use App\Models\PendingSaleOrderOLD as PendingSaleOrder;

use Illuminate\Support\Facades\Log;

use Illuminate\Http\Request;

class NotificationController
{
	public function notificationKP(Request $request)
	{
       $headers = [
            'Content-type' => 'application/json',
            'Authorization' => 'Bearer '.config('ts-lib-pay.kueskipay.keys.token')
        ];
        
        Log::info(json_encode([
            "ResponseKueskipay" => $request->all() ,
		"head" => $headers,
        ]));

        if($request->get('sandbox')==true){
            Log::warning(json_encode([
                "message" => "IMPORTANTE - respuesta de kueskipay marca servidor de SANDBOX",
                "dataKueski" => $request->all() 
            ]));
        }

        $IdOrderTecno = 0;
        $statusKP = $request->get('status')=='approved' ? 'accept' : 'ok';
        $autopago=false;
        if($request->get('order_id')){
            $orderTecno = explode('-',$request->get('order_id'));
            if(substr($orderTecno[0],0,1) === 'P'){
                $autopago = true;
            }
            $IdOrderTecno = count($orderTecno)>0?(int) $orderTecno[1]:0;
        }

        if($autopago===false){
            $response = $this->searchOrderById($IdOrderTecno);
            if($response["find"]===true){
                Log::info(json_encode([
                    "message" => "Order - Encontrada con status 3 ya esta procesada, respuesta desde Kueskipay",
                    "status-KP" => $request->get('status'),
                    "message-kp" => $request->get('status_reason'),
                    "payment-id-KP" => $request->get('payment_id'),
                    "order-id-base" => $request->get('order_id')
                ]));
                return response()->json([
                    "status" => $statusKP
                ],200,$headers);
            }
            $response = $this->searchOrderIdExternal($request->get('payment_id'));
            if($response["find"]===true){
                Log::info(json_encode([
                    "message" => "Order - Encontrada mediante paypal_code, respuesta desde Kueskipay",
                    "status-KP" => $request->get('status'),
                    "message-kp" => $request->get('status_reason'),
                    "payment-id-KP" => $request->get('payment_id'),
                    "order-id-base" => $request->get('order_id')
                ]));
                return response()->json([
                    "status" => $statusKP
                ],200,$headers);
            }
            $order = $response['order'];


            switch ($request->get('status')) {
                case 'approved'://credito aceptado pagado por kueskipay
                        $dataOrder["type_payment"] = "Pago en línea";
                        $dataOrder['paypal_code'] = $request->get('payment_id');
                        $dataOrder["paypal_amount"] = round($request->get('amount'),2);
                        $dataOrder["status"] = "0";
                        Log::info(json_encode([
                            "message" => "Order - OK crédito aprobado por parte de Kueskipay, order subir a NS",
                            "status-KP" => $request->get('status'),
                            "message-kp" => $request->get('status_reason'),
                            "payment-id-KP" => $request->get('payment_id'),
                            "order-id-base" => $request->get('order_id')
                        ]));
                    break;
                case 'canceled'://credito cancelado por kueskipay
                        $dataOrder["type_payment"] = "Transferencia, deposito o pago en sucursal";
                        $dataOrder["status"] = "9";
                        Log::info(json_encode([
                            "message" => "Order - CANCELED crédito cancelado por kueskipay, order se queda en status 9",
                            "status-KP" => $request->get('status'),
                            "message-kp" => $request->get('status_reason'),
                            "payment-id-KP" => $request->get('payment_id'),
                            "order-id-base" => $request->get('order_id')
                        ]));
                    break;
                case 'denied'://denegado por kueskipay
                        $dataOrder["type_payment"] = "Transferencia, deposito o pago en sucursal";
                        $dataOrder["status"] = "9";
                        Log::info(json_encode([
                            "message" => "Order - DENIED crédito denegado por kueskipay, order se queda en status 9",
                            "status-KP" => $request->get('status'),
                            "message-kp" => $request->get('status_reason'),
                            "payment-id-KP" => $request->get('payment_id'),
                            "order-id-base" => $request->get('order_id')
                        ]));
                    break;
                default:
                    Log::info(json_encode([
                        "message" => "STATUS no encontrado, revisar respuesta de KueskiPay",
                        "data-KP" => $request->all(),
                    ]));
                    return response()->json([
                        "status" => $statusKP
                    ],200,$headers);
                    break;
            }
    
            try{ // actualizar order para subir a NS 
                PendingSaleOrder::where('id',$IdOrderTecno)->update($dataOrder);
                //$this->createPedidoNS($order);
            } catch (\Exception $e) {
                Log::error(json_encode([
                    "message" => "Error al procesar order de kueskipya con Tecno Error: ".$e->getMessage(),
                    "data-KP" => $request->all(),
                ]));
            }
        }else{
            switch ($request->get('status')) {
                case 'approved'://credito aceptado pagado por kueskipay
                    $messageLog = "(AUTOPAGO) OK crédito aprobado por parte de Kueskipay, order subir a NS";
                    $ns = new NetsuiteRestlet();
                    $json = [
                        "salesorderref" => (int) $IdOrderTecno,
                        "paymentamount" => (Float) round($request->get('amount'),2),
                        "paymentref" => (String) $request->get('payment_id'),
                        "type" => "autopago:kueskipay",
                        "payment_file_id" => ""
                    ];
                    $responseNS = [];
                    try {
                        $responseNS = $ns->restlet('POST', 'payment_saleorder', [], @json_encode($json));
                        if($responseNS["status"]==true){
                            Log::info(json_encode([
                                "message" => $messageLog,
                                "status-KP" => $request->get('status'),
                                "message-kp" => $request->get('status_reason'),
                                "payment-id-KP" => $request->get('payment_id'),
                                "order-id" => $request->get('order_id')
                            ]));
                        }else{
                            Log::error(json_encode([
                                "message" => "(AUTOPAGO) Error al ingresar el pago kueskipay",
                                "function" => "CheckoutController.successOrderKP",
                                "data" => $json,
                                "response-NS" => $responseNS 
                            ]));
                        }
                    } catch (\Exception $e) {
                        Log::error(json_encode([
                            "message" => "(AUTOPAGO) Error al ingresar el pago kueskipay - error: ".$e->getMessage(),
                            "function" => "CheckoutController.successOrderKP",
                            "data" => $json,
                            "response-NS" => $responseNS 
                        ]));
                    }
                    return response()->json([
                        "status" => $statusKP
                    ],200,$headers);
                    break;
                case 'canceled'://credito cancelado por kueskipay
                    $messageLog = "(AUTOPAGO) CANCELED crédito cancelado por kueskipay, sin subir a NS";
                    break;
                case 'denied'://denegado por kueskipay
                    $messageLog = "(AUTOPAGO) DENIED crédito denegado por kueskipay, sin subir a NS";
                    break;
                default:
                    Log::info(json_encode([
                        "message" => " (AUTOPAGO) STATUS no encontrado, revisar respuesta de KueskiPay",
                        "data-KP" => $request->all(),
                    ]));
                    return response()->json([
                        "status" => $statusKP
                    ],200,$headers);
                    break;
            }
            Log::info(json_encode([
                "message" => $messageLog,
                "status-KP" => $request->get('status'),
                "message-kp" => $request->get('status_reason'),
                "payment-id-KP" => $request->get('payment_id'),
                "order-id-base" => $request->get('order_id')
            ]));
	}

        return response()->json([
            "status" => $statusKP
        ],200,$headers);
    }

    public function searchOrderById($id=null)
    {
        $order = PendingSaleOrder::where('id',$id)->first();
        if($order!=null){
            if($order->status == 3){
               return ["find" => true, "order" => $order];
            }
        }

        return ["find" => false, "order" => (Object) []];
    }

    public function searchOrderIdExternal($id=null)
    {
        $order = PendingSaleOrder::where('paypal_code',$id)->first();
        if($order!=null){
            return ["find" => true, "order" => $order];
        }
        return ["find" => false, "order" => (Object) []];
    }

    public function notificationKT(Request $request, KtService $kt)
    {
        Log::info(json_encode(['responseKalto' => $request->all()]));
        $paymentOrderId = $request->get('id');
        $salesOrderId = $request->get('salesorder');
        $event = $request->get('event');
        $topic = $request->get('topic');
        $id = $request->get("id");

        switch ($topic) {
            case 'payment-orders':
                $payment = $kt->searchPayment($paymentOrderId);

                if(!$payment)
                {
                    return response()->json(['status' => false, 'msg' => sprintf('Payment %s no encontrado', $paymentOrderId)]);
                }

                $result_process = $kt->process_notification_payment($payment, $salesOrderId);

                return $result_process;
                break;
            default:
                Log:error(sprintf('Topico %s no reconocido', $topic));
                break;
        }
    }
}
