<?php 

namespace TsLib\Pay\Services;


use TsLib\Rest\Services\Curl;
use Illuminate\Support\Facades\Log;

class TsKalto {

    protected $token;

    protected $curl = null;

    public function __construct()
    {
        $headers = [
            'Content-type: application/json',
            'Accept: */*',
            'X-Merchant-Key:'.config('ts-lib-pay.kalto.merchant_key'),
            'Authorization: Basic '.base64_encode(config('ts-lib-pay.kalto.user').':'.config('ts-lib-pay.kalto.password')),
        ];
        if(config('ts-lib-pay.kalto.ambiente') == 'production')
        {
            $url = 'https://api.kalto.la/kalto/api/v1';
        }
        else
        {
            $url = 'https://api-sbx.kalto.la/kalto/api/v1';
        }

        $this->curl = new Curl($url, [], [CURLOPT_HTTPHEADER => $headers]);
    }

    public function searchPayment($paymentOrderId)
    {
        $result = $this->curl->get(sprintf('payment-orders/%s', $paymentOrderId));
        
        if(!in_array($result['httpCode'], [200, 201]))
        {
            Log::error(sprintf('No se pudo recibir el resultado de consulta del pago Kalto %s', $paymentOrderId));
            return false;
        }

        return $result['body'];
    }

    public function process_notification_payment($payment, $salesOrderId)
    {
        Log::info(json_encode(['kaltoPaymentSubmitted' => $payment]));
        switch ($payment->status) {
            case 'SUBMITTED':
                return true;
                break;
            case 'COMPLETED':
                $json = [
                    "salesorderref" => $salesOrderId,
                    "paymentamount" => (Float) round($payment->paidAmount,2),
                    "paymentref" => (String) $payment->id,
                    "type" => "kalto",
                    "payment_file_id" => ""
                ];
                $responseNS = [];
                try {
                    $responseNS = $ns->restlet('POST', 'payment_saleorder', [], @json_encode($json));
                    if($responseNS["status"]==true){
                        Log::info(json_encode([
                            "message" => $messageLog,
                            "status-KP" => $request->get('status'),
                            "message-kp" => $request->get('status_reason'),
                            "payment-id-KP" => $request->get('payment_id'),
                            "order-id" => $request->get('order_id')
                        ]));
                    }else{
                        Log::error(json_encode([
                            "message" => "(AUTOPAGO) Error al ingresar el pago kueskipay",
                            "function" => "CheckoutController.successOrderKP",
                            "data" => $json,
                            "response-NS" => $responseNS 
                        ]));
                    }
                } catch (\Exception $e) {
                    Log::error(json_encode([
                        "message" => "(AUTOPAGO) Error al ingresar el pago kueskipay - error: ".$e->getMessage(),
                        "function" => "CheckoutController.successOrderKP",
                        "data" => $json,
                        "response-NS" => $responseNS 
                    ]));
                }

                break;
            default:
                // code...
                break;
        }
    }

}