<?php

namespace TsLib\Rest\Services;

class NetsuiteRest {

    protected $tokenKey;
    protected $tokenSecret;
    protected $consumerKey;
    protected $consumerSecret;
    protected $signatureMethod;
    protected $nonce;
    protected $timestamp;
    protected $version;
    protected $realm;

    public function __construct()
    {
        date_default_timezone_set ('America/Mexico_City');
        $this->tokenKey =  config('ts-lib-rest.token_key');
        $this->tokenSecret = config('ts-lib-rest.token_secret');
        $this->consumerKey = config('ts-lib-rest.consumer_key');
        $this->consumerSecret = config('ts-lib-rest.consumer_secret');
        $this->realm = config('ts-lib-rest.account');
        $this->signatureMethod = "HMAC-SHA256";
        $this->version = "1.0";
    }

   public function _jsonValidator($json)
    {
        if (!empty($json)) {
            @json_decode($json);
            return (json_last_error() === JSON_ERROR_NONE);
        }
        return false;
    }

    public function _wrapperAcentos($text="")
    {
        return htmlentities(html_entity_decode(utf8_encode($text)));
    }

    public function _restletBaseString($httpMethod, $url, $consumerKey, $tokenKey, $nonce, $timestamp, $version, $signatureMethod)
    {

        if (strpos($url, '?')){  
            $baseUrl = substr($url, 0, strpos($url, '?'));
            $getParams = substr($url, strpos($url, '?') + 1);
        } else {
            $baseUrl = $url;
            $getParams = "";
        }

        $restlet = [];
        if($getParams!=""){
            $restlet = explode('&',$getParams);
        }

        $baseString = strtoupper($httpMethod).'&'.rawurlencode($baseUrl).'&';

        $params = $values = [];
        foreach($restlet as $par){
            $val = explode("=",$par);
            $values[]=$val[0];
        }
       
        if(in_array("customer_id",$values)){
            $params["customer_id"] = substr($restlet[2],strpos($restlet[2], '=')+1,10);
        }
        if(in_array("deploy",$values)){
            $params["deploy"] = substr($restlet[1],strpos($restlet[1], '=')+1,10);
        }
        if(in_array("month",$values)){
            $params["month"] = substr($restlet[3],strpos($restlet[3], '=')+1,10);
        }
        $params['oauth_consumer_key'] = $consumerKey;
        $params['oauth_nonce'] = $nonce;
        $params['oauth_signature_method'] = $signatureMethod;
        $params['oauth_timestamp'] = $timestamp;
        $params['oauth_token'] = $tokenKey;
        $params['oauth_version'] = $version;
        if(in_array("script",$values)){
            $params["script"] = substr($restlet[0],strpos($restlet[0], '=')+1,10);
        }
        if(in_array("tranid",$values)){
            $params["tranid"] = substr($restlet[2],strpos($restlet[2], '=')+1,10);
        }
        if(in_array("year",$values)){
            $params["year"] = substr($restlet[4],strpos($restlet[4], '=')+1,10);
        }
        
        $paramString = "";
        foreach ($params as $key => $value){
            $paramString .= rawurlencode($key) . '='. rawurlencode($value) .'&';
        }

        $paramString = substr($paramString, 0, -1);
        $baseString .= rawurlencode($paramString);

        return $baseString;
    }

    public function _client_curl_send($httpMethod,$url,$headers=[],$json="")
    {
        if($httpMethod == "POST"){
            $options = [
                CURLOPT_URL => $url,  
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $httpMethod,
                CURLOPT_POSTFIELDS => $json,
                CURLOPT_HTTPHEADER => $headers,
            ];
        }else{
            $options = [
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $httpMethod,
                CURLOPT_HTTPHEADER => $headers
            ];
        }
        $curl = curl_init();
        curl_setopt_array($curl, $options);
        $response = curl_exec($curl);
        curl_close($curl);

        return json_decode($response);
    }

    public function getInfoNetsuite($httpMethod,$url,$json="")
    {
        $url = sprintf('https://%s.suitetalk.api.netsuite.com/services/rest/', strtolower(str_replace('_', '-', $this->realm))).$url;
        $resp = ["status" => false,"data" => [],"message"=>"Error api get"];
        $nonce = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 20);
        $timestamp = time();

        if($httpMethod == "POST"){
            $validateJSON = $this->_jsonValidator($json);
            if($validateJSON != 1){
                $response["message"] = "JSON error";
                return $resp;
            }
        }

        $key = rawurlencode($this->consumerSecret) .'&'. rawurlencode($this->tokenSecret);
        
        $baseString = $this->_restletBaseString($httpMethod, $url, $this->consumerKey, $this->tokenKey, 
        $nonce, $timestamp, $this->version, $this->signatureMethod);

        $signature = base64_encode(hash_hmac('sha256', $baseString, $key, true));

        $tokenComplet = 'Authorization: OAuth '
                        .'realm="' .rawurlencode($this->realm) .'", '
                        .'oauth_consumer_key="' .rawurlencode($this->consumerKey) .'", '
                        .'oauth_token="' .rawurlencode($this->tokenKey) .'", '
                        .'oauth_nonce="' .rawurlencode($nonce) .'", '
                        .'oauth_timestamp="' .rawurlencode($timestamp) .'", '
                        .'oauth_signature_method="' .rawurlencode($this->signatureMethod) .'", '
                        .'oauth_version="' .rawurlencode($this->version) .'", '
                        .'oauth_signature="' .rawurlencode($signature) .'"';

        $header = [
            $tokenComplet,
            'Content-type:application/json'
        ];

        if($httpMethod == "POST"){
            $options = [
                CURLOPT_URL => $url,  
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $httpMethod,
                CURLOPT_POSTFIELDS => $json,
                CURLOPT_HTTPHEADER => $header,
                CURLOPT_HEADER => 1
            ];
        }else{
            $options = [
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $httpMethod,
                CURLOPT_HTTPHEADER => $header
            ];
        }
        $curl = curl_init();
        curl_setopt_array($curl, $options);
        $response = curl_exec($curl);
        $headerSize = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
        $header = substr($response, 0, $headerSize);
        $bodyHead = substr($response, $headerSize);
        $resp["code"] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);

        $result = json_decode($response);
        $resp["message"] = json_decode($response);

        $arrayHead = explode("\\r\\n",json_encode($header));

        $location = $responseCode = [];
        foreach ($arrayHead as $head) {
            if(strstr($head,"Location:")==true){
                $location = explode("\/",$head);
            }
            if(strstr($head,"HTTP")==true){
                $responseCode = explode(" ",$head);
            }
        }

        if($httpMethod == "POST"){

            $arrayJson = json_decode($json);
            $resultNS = json_decode($bodyHead);
           
            if(array_key_exists("filetype",$arrayJson)){
                if($resultNS!=null && property_exists($resultNS,"code")){
                    if($resultNS->code){
                        $resp["data"] = $resultNS->fileid;
                        $resp["status"] = true;
                    }
                }
            }elseif($resultNS!=null && property_exists($resultNS,"code")){
                if($resultNS->code){
                    $resp["data"] = $resultNS;
                    $resp["status"] = true;
                }
            }else{
                if(json_decode($bodyHead) == null && count($location)>0){
                    $resp["data"] = $location[count($location)-1];
                    $resp["status"] = true;
                }
            }
            $resp["message"] = json_decode($bodyHead) ? json_decode($bodyHead) : json_decode($response);
        }

        if($httpMethod == "GET"){
            if($result){

                $resp["data"] = $result;
                $resp["status"] = true;
                $resp["message"] = "Resultado correcto";
            }
        }

        return $resp;
    }

}