<?php

namespace TsLib\Rest\Services;

class BaseNetsuite {
	
    protected $tokenKey;
    protected $tokenSecret;
    protected $consumerKey;
    protected $consumerSecret;
    protected $signatureMethod;
    protected $nonce;
    protected $timestamp;
    protected $version;
    protected $realm;

    public function __construct()
    {
        date_default_timezone_set ('America/Mexico_City');
        $this->tokenKey =  config('ts-lib-rest.token_key');
        $this->tokenSecret = config('ts-lib-rest.token_secret');
        $this->consumerKey = config('ts-lib-rest.consumer_key');
        $this->consumerSecret = config('ts-lib-rest.consumer_secret');
        $this->realm = config('ts-lib-rest.account');
        $this->signatureMethod = "HMAC-SHA256";
        $this->version = "1.0";
    }


   public function _jsonValidator($json)
    {
        if (!empty($json)) {
            @json_decode($json);
            return (json_last_error() === JSON_ERROR_NONE);
        }
        return false;
    }

    public function _wrapperAcentos($text="")
    {
        return self::wrapperAcentos($text);
    }

    static public function wrapperAcentos($text="")
    {
        return htmlentities(html_entity_decode(utf8_encode($text)));
    }

    public function _restletBaseString($httpMethod, $url, $consumerKey, $tokenKey, $nonce, $timestamp, $version, $signatureMethod)
    {

        if (strpos($url, '?')){  
            $baseUrl = substr($url, 0, strpos($url, '?'));
            $getParams = substr($url, strpos($url, '?') + 1);
        } else {
            $baseUrl = $url;
            $getParams = "";
        }

        $restlet = [];
        if($getParams!=""){
            $restlet = explode('&',$getParams);
        }

        $baseString = strtoupper($httpMethod).'&'.rawurlencode($baseUrl).'&';

        $params = $values = [];
        foreach($restlet as $par){
            $val = explode("=",$par);
            $values[]=$val[0];
        }
       
        if(in_array("customer_id",$values)){
            $params["customer_id"] = substr($restlet[2],strpos($restlet[2], '=')+1,10);
        }
        if(in_array("deploy",$values)){
            $params["deploy"] = substr($restlet[1],strpos($restlet[1], '=')+1,10);
        }
        if(in_array("month",$values)){
            $params["month"] = substr($restlet[3],strpos($restlet[3], '=')+1,10);
        }
        $params['oauth_consumer_key'] = $consumerKey;
        $params['oauth_nonce'] = $nonce;
        $params['oauth_signature_method'] = $signatureMethod;
        $params['oauth_timestamp'] = $timestamp;
        $params['oauth_token'] = $tokenKey;
        $params['oauth_version'] = $version;
        if(in_array("script",$values)){
            $params["script"] = substr($restlet[0],strpos($restlet[0], '=')+1,10);
        }
        if(in_array("tranid",$values)){
            $params["tranid"] = substr($restlet[2],strpos($restlet[2], '=')+1,10);
        }
        if(in_array("year",$values)){
            $params["year"] = substr($restlet[4],strpos($restlet[4], '=')+1,10);
        }
        
        $paramString = "";
        foreach ($params as $key => $value){
            $paramString .= rawurlencode($key) . '='. rawurlencode($value) .'&';
        }

        $paramString = substr($paramString, 0, -1);
        $baseString .= rawurlencode($paramString);

        return $baseString;
    }

    public function _client_curl_send($httpMethod,$url,$headers=[],$json="")
    {
        $httpMethod = strtoupper($httpMethod);
        if($httpMethod == "POST"){
            $options = [
                CURLOPT_URL => $url,  
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $httpMethod,
                CURLOPT_POSTFIELDS => $json,
                CURLOPT_HTTPHEADER => $headers,
            ];
        }else{
            $options = [
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $httpMethod,
                CURLOPT_HTTPHEADER => $headers
            ];
        }
        $curl = curl_init();
        curl_setopt_array($curl, $options);
        $response = curl_exec($curl);
        curl_close($curl);

        return json_decode($response);
    }
}