<?php

namespace TsLib\Rest\Services;

class NetsuiteRest extends BaseNetsuite {

    public function doRequest($httpMethod,$path,$json="")
    {
        $url = sprintf('https://%s.suitetalk.api.netsuite.com/services/rest/', strtolower(str_replace('_', '-', $this->realm))).$path;
        $resp = ["status" => false,"data" => [],"message"=>"Error api get"];
        $nonce = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 20);
        $timestamp = time();

        if($httpMethod == "POST"){
            $validateJSON = $this->_jsonValidator($json);
            if($validateJSON != 1){
                $response["message"] = "JSON error";
                return $resp;
            }
        }

        $key = rawurlencode($this->consumerSecret) .'&'. rawurlencode($this->tokenSecret);
        
        $baseString = $this->_restletBaseString($httpMethod, $url, $this->consumerKey, $this->tokenKey, 
        $nonce, $timestamp, $this->version, $this->signatureMethod);

        $signature = base64_encode(hash_hmac('sha256', $baseString, $key, true));

        $tokenComplet = 'Authorization: OAuth '
                        .'realm="' .rawurlencode($this->realm) .'", '
                        .'oauth_consumer_key="' .rawurlencode($this->consumerKey) .'", '
                        .'oauth_token="' .rawurlencode($this->tokenKey) .'", '
                        .'oauth_nonce="' .rawurlencode($nonce) .'", '
                        .'oauth_timestamp="' .rawurlencode($timestamp) .'", '
                        .'oauth_signature_method="' .rawurlencode($this->signatureMethod) .'", '
                        .'oauth_version="' .rawurlencode($this->version) .'", '
                        .'oauth_signature="' .rawurlencode($signature) .'"';

        $header = [
            $tokenComplet,
            'Content-type:application/json'
        ];

        if($httpMethod == "POST"){
            $options = [
                CURLOPT_URL => $url,  
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $httpMethod,
                CURLOPT_POSTFIELDS => $json,
                CURLOPT_HTTPHEADER => $header,
                CURLOPT_HEADER => 1
            ];
        }else{
            $options = [
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $httpMethod,
                CURLOPT_HTTPHEADER => $header,
                CURLOPT_HEADER => true,
            ];
        }
        $curl = curl_init();
        curl_setopt_array($curl, $options);
        $response = curl_exec($curl);
        $headerSize = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
        $headers_text = substr($response, 0, $headerSize);
        $body = substr($response, $headerSize);
        $code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);

        $headers = [];
        foreach (explode("\\r\\n",json_encode($headers_text)) as $header) {
            $parts = explode(": ", $header);
            if(isset($parts[1]))
            {
                $headers[$parts[0]] = $parts[1];
            }
            else
            {
                $headers[$parts[0]] = "";
            }
        }

        if(in_array($code, [200, 204]))
        {
            $toReturn = [
                "status" => true,
                "message" => "Resultado correcto",
            ];
        }
        else
        {
            $toReturn = [
                "status" => false,
                "message" => "Error generico de Rest",
            ];
        }

        $toReturn["data"] = json_decode($body);

        return $toReturn;

        if($httpMethod == "POST"){

            $arrayJson = json_decode($json);
            $resultNS = json_decode($bodyHead);
           
            if(array_key_exists("filetype",$arrayJson)){
                if($resultNS!=null && property_exists($resultNS,"code")){
                    if($resultNS->code){
                        $resp["data"] = $resultNS->fileid;
                        $resp["status"] = true;
                    }
                }
            }elseif($resultNS!=null && property_exists($resultNS,"code")){
                if($resultNS->code){
                    $resp["data"] = $resultNS;
                    $resp["status"] = true;
                }
            }else{
                if(json_decode($bodyHead) == null && count($location)>0){
                    $resp["data"] = $location[count($location)-1];
                    $resp["status"] = true;
                }
            }
            $resp["message"] = json_decode($bodyHead) ? json_decode($bodyHead) : json_decode($response);
        }

        if($httpMethod == "GET"){
            if($result){

                $resp["data"] = $result;
                $resp["status"] = true;
                $resp["message"] = "Resultado correcto";
            }
        }

        return $resp;
    }

}