<?php

namespace TsLib\Rest\Ns;

use TsLib\Rest\Services\NetsuiteRest;
use Illuminate\Support\Facades\Log;

class Base
{
	static protected $path = '';
	static private $base_rest_services = 'https://%s.suitetalk.api.netsuite.com/services/rest/';
	protected $rest_path = '';
	protected $filters = [];

	protected $id = null;
	protected $record = ['instance' => null, 'class' => null];

	protected $ns = null;

	public function __construct($options = [])
	{
		$this->ns = new NetsuiteRest();
		if(isset($options['record']))
		{
			$this->record['instance'] = $options['record'];
		}
		
		if(isset($options['id']))
		{
			$this->id = $options['id'];
		}
	}

	private function ns()
	{
		if(get_class($this->ns) != NetsuiteRest::class)
		{
			$this->ns = new NetsuiteRest();
		}

		return $this->ns;
	}

	private static function _ns()
	{
		return (new static)->ns();
	}

	private function get_path($extra = '')
	{
		if(get_class($this) == 'TsLib\\Rest\\Ns')
		{
			Log::error("No se puede hace el path de clase Base");
			return false;
		}

		$class = substr(get_class($this),  strrpos(get_class($this), '\\') + 1);

		return sprintf(self::$base_rest_services.'%s%s%s', strtolower(str_replace('_', '-', config('ts-lib-rest.account'))), $this->rest_path, $class, $extra);
	}

	private static function _get_path($extra = '')
	{
		return (new static)->get_path($extra);		
	}

	private static function _get_filters()
	{
		return (new static)->filters;
	}

	public static function all()
	{
		return self::_ns()->get(self::_get_path());
	}

	public static function find($id)
	{
		return self::_ns()->get(self::_get_path('/'.$id));
	}

	public static function where($filters = [])
	{
		$parsed = [];
		$class_filters = self::_get_filters();
		$query = [];
		foreach($filters as $field => $value)
		{
			if(isset($class_filters[$field]))
			{
				$field = $class_filters[$field];
			}

			if(in_array($field, $class_filters))
			{
				$field = $class_filters[array_search($field, $class_filters)];
			}

			//ToDo: Esto debe de ser definido en $filters
			if(is_numeric($value))
				$query[] = $field . ' EQUALS ' . $value;
			else
				$query[] = $field . ' IS ' . $value;
		}

		return self::_ns()->get(self::_get_path(), ['q' => implode(' AND ', $query)]);
	}
}