<?php

namespace TsLib\Sso\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

use TsLib\Sso\Models\SSOToken;
use TsLib\Sso\Models\CustomerSalesRep;

class SSOController extends Controller
{
    //
    public function token(Request $request)
    {
        $getToken = SSOToken::where('token', $request->get('t'))->orderBy('created_at', 'DESC')->first();

        if($getToken == null)
        {
            Log::error(sprintf('Se intentó hacer login con una token %s no válida', $request->get('t')));
            return redirect()->route('home'); //ToDo: cambiar esto a config()
        }

        $date = Carbon::now();
        //Log::info($date->diffInMinutes($getToken->created_at));
        if($date->diffInMinutes($getToken->created_at) > 3)
        {
            Log::error(sprintf('El usuario %s intentó hacer login con una token %s expirada', $getToken->sales_rep_id, $request->get('t')));
            return redirect()->route('home');//ToDo: cambiar esto a config()
        }

        $user = CustomerSalesRep::find($getToken->sales_rep_id);
        Auth::login($user);

        return redirect()->route('home');//ToDo: cambiar esto a config()
    }
}
