<?php

namespace TsLib\Sso\Models;

use Illuminate\Database\Eloquent\Model;

class Website extends Model
{
    //
    protected $table = 'websites';

    public static function getAppsURL()
    {
        $site = Website::firstWhere('name', 'Apps');

        if($site == null)
        {
            \Illuminate\Support\Facades\Log::error('No está configurada la URL del Website Apps');
            return '#';
        }

        if(\App::environment() == 'production')
        {
            return $site->url_produccion;
        }
        else
        {
            return $site->url_pruebas;
        }
    }
}
